/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.jellyfishingdelight.mixin;

import club.someoneice.jellyfishingdelight.core.BlockList;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;

@Mixin(value={CookingPotBlockEntity.class})
public abstract class CookingPotMixin {
    @Shadow(remap=false)
    private int cookTime;
    @Shadow(remap=false)
    private int cookTimeTotal;
    @Shadow(remap=false)
    private ItemStack mealContainerStack;

    @Shadow(remap=false)
    protected abstract void ejectIngredientRemainder(ItemStack var1);

    @Inject(method={"processCooking"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void reProcessCooking(CookingPotRecipe recipe, CookingPotBlockEntity thiz, CallbackInfoReturnable<Boolean> cir) {
        Level world = thiz.m_58904_();
        if (Objects.isNull(world) || world.m_5776_() || !((Boolean)thiz.m_58900_().m_61143_((Property)CookingPotBlock.WATERLOGGED)).booleanValue() || !world.m_8055_(thiz.m_58899_().m_7495_()).m_60713_((Block)BlockList.GRILL.get())) {
            return;
        }
        this.cookTimeTotal = Mth.m_14107_((double)((double)recipe.getCookTime() * 0.7));
        ++this.cookTime;
        if (this.cookTime < this.cookTimeTotal) {
            cir.setReturnValue((Object)false);
            return;
        }
        this.cookTime = 0;
        this.mealContainerStack = recipe.getOutputContainer();
        ItemStack resultStack = recipe.m_8043_(world.m_9598_());
        ItemStack storedMealStack = thiz.getInventory().getStackInSlot(6);
        if (storedMealStack.m_41619_()) {
            thiz.getInventory().setStackInSlot(6, resultStack.m_41777_());
        } else if (ItemStack.m_41656_((ItemStack)storedMealStack, (ItemStack)resultStack)) {
            storedMealStack.m_41769_(resultStack.m_41613_());
        }
        thiz.m_6029_((Recipe)recipe);
        for (int i = 0; i < 6; ++i) {
            ItemStack slotStack = thiz.getInventory().getStackInSlot(i);
            if (slotStack.hasCraftingRemainingItem()) {
                this.ejectIngredientRemainder(slotStack.getCraftingRemainingItem());
            } else if (CookingPotBlockEntity.INGREDIENT_REMAINDER_OVERRIDES.containsKey(slotStack.m_41720_())) {
                this.ejectIngredientRemainder(((Item)CookingPotBlockEntity.INGREDIENT_REMAINDER_OVERRIDES.get(slotStack.m_41720_())).m_7968_());
            }
            if (slotStack.m_41619_()) continue;
            slotStack.m_41774_(1);
        }
        cir.setReturnValue((Object)true);
    }
}

